

var oButtonGrabSegment1 = new sap.m.Button({id:"grabSegment1",text:oBundle.getText("Today")});
var oButtonGrabSegment2 = new sap.m.Button({id:"grabSegment2",text:oBundle.getText("Last_7_Days")});
var oButtonGrabSegment3 = new sap.m.Button({id:"grabSegment3",text:oBundle.getText("Last_30_Days")});
var oButtonGrabSegment4 = new sap.m.Button({id:"grabSegment4",text:oBundle.getText("Last_90_Days")});
var oButtonGrabSegment5 = new sap.m.Button({id:"grabSegment5",text:oBundle.getText("Custom_Date")});

var customDateHome1 = new sap.m.DatePicker({width: "150px",displayFormat: "dd-MMM-yyyy",valueFormat: "dd-MMM-yyyy"});
var customDateHome2 = new sap.m.DatePicker({width: "150px",displayFormat: "dd-MMM-yyyy",valueFormat: "dd-MMM-yyyy"});

var customDateBlock = new sap.ui.layout.BlockLayoutRow({visible :false,
	content: [new sap.ui.layout.BlockLayoutCell({width: 1,
			content: [	customDateHome1,customDateHome2,
				new sap.m.Button({ text: oBundle.getText("Go"), width: "50px",
				press: function (oEvent) {
					var oDateStart = customDateHome1.getValue();
					var oDateEnd = customDateHome2.getValue();

					if (validation(oDateStart, oBundle.getText("Start_Date"))) { return; }
					if (validation(oDateEnd, oBundle.getText("End_Date"))) { return; }

					if (!customDateHome1.isValidValue() || !customDateHome2.isValidValue()) {
						sap.m.MessageBox.error(oBundle.getText("Invalid") + " " + oBundle.getText("Date"));
						return;
					}
				
					var oDateStart1 = new Date(oDateStart);  
					var oDateEnd1 = new Date(oDateEnd);  
					if (oDateStart1 > oDateEnd1 ) {
						sap.m.MessageBox.error(oBundle.getText("Start_date_should_be_lower_than_end_date"));
						return;
					}
					dateFilterGrabData(oDateStart1,oDateEnd1);
				} 
			})]
		})]
});


var SegmentedGrabGroup = new sap.m.SegmentedButton({
		buttons: [oButtonGrabSegment1, oButtonGrabSegment2,oButtonGrabSegment3,oButtonGrabSegment4,oButtonGrabSegment5],
		selectedButton: oButtonGrabSegment1,
		select: function(oEvent) {
			
           var btnId = oEvent.getParameter('id');
           var current_date = getCurrentDate();
           var current = new Date(current_date);     

            if(btnId=="grabSegment1"){
				dateFilterGrabData(current,current);
            }else if(btnId=="grabSegment2"){

				var last7Date = new Date(current_date);
				var pastDate = last7Date.getDate()-7;
				last7Date.setDate(pastDate);

                dateFilterGrabData(last7Date,current);
            }else if(btnId=="grabSegment3"){

				var last30Date = new Date(current_date);
				var pastDate = last30Date.getDate()-30;
				last30Date.setDate(pastDate);
				 
				dateFilterGrabData(last30Date,current);
				
            }else if(btnId=="grabSegment4"){  

				var last90Date = new Date(current_date);
				var pastDate = last90Date.getDate()-90;
				last90Date.setDate(pastDate);
				 
				dateFilterGrabData(last90Date,current);
			}
			
			if(btnId=="grabSegment5"){  
				customDateBlock.setVisible(true);
            }else{
				customDateBlock.setVisible(false);
			}
		}
	});



function dateFilterGrabData(oDate1,oDate2){
	
	segmentedDate1 = oDate1;
	segmentedDate2 = oDate2;

	oDate1 = oDate1.toISOString().split('T')[0] +  " 00:00:00.0000000 +00:00"; 
	// oDate2 = oDate2.toISOString().split('T')[0] +  " 00:00:00.0000000 +00:00"; 

	
    const dateValue2 = new Date();
    dateValue2.setDate(dateValue2.getDate() + 1);
    const formattedDate2 = dateValue2.toISOString().split('T')[0] +  " 00:00:00.0000000 +00:00";

	dashboardWorkorderInspectionCount(oDate1, formattedDate2)
		// $.ajax({
		// 	url: funGetInspection(oDate1,oDate2),
		// 	success:function(){
		// 		assignWorkorderDashboardCount(oDate1,oDate2);
		// 	}
		// });
}


//-------------------------------------------------GRAB Workorder Home Start-----------------------------------------------------------------
{
var grabHomeList1 = new sap.m.List({
	showUnread: true,
	backgroundDesign: sap.m.BackgroundDesign.Solid
}).addStyleClass("homelist");

var woGrabStatuslistItem1 = new sap.m.StandardListItem({
	title: oBundle.getText("Total_Work_Order"),
	icon: sap.ui.core.IconPool.getIconURI("wrench"),
	iconInset: true,unread: false,info: "0",//type:"Navigation",
	infoState: "Error",
	// press:function (event){
	// 	sideNavigation.setSelectedKey("p31");
	// 	navContainer.to("p31");
	// 	var oModel = new sap.ui.model.json.JSONModel();
	// 	oModel.setData({ modelData: totalWoJSONArray });
	// 	oTableWorkorder.setModel(oModel);
	// 	oTableWorkorder.bindItems({
	// 		path: "/modelData",
	// 		template: workorderTemplate
	// 	});
	// }
});
var woGrabStatuslistItem2 = new sap.m.StandardListItem({
	title: oBundle.getText("Completed"),
	icon: sap.ui.core.IconPool.getIconURI("complete"),
	iconInset: true,unread: false,info: "0",//type:"Navigation",
	infoState: "Error",
	// press:function (event){
	// 	sideNavigation.setSelectedKey("p31");
	// 	navContainer.to("p31");
	// 	var oModel = new sap.ui.model.json.JSONModel();
	// 	oModel.setData({ modelData: completedWoJSONArray });
	// 	oTableWorkorder.setModel(oModel);
	// 	oTableWorkorder.bindItems({
	// 		path: "/modelData",
	// 		template: workorderTemplate
	// 	});
	// }
});
var woGrabStatuslistItem3 = new sap.m.StandardListItem({
	title: oBundle.getText("Open"),
	icon: sap.ui.core.IconPool.getIconURI("create"),
	iconInset: true,unread: false,info: "0",//type:"Navigation",
	infoState: "Error",
	// press:function (event){
	// 	sideNavigation.setSelectedKey("p31");
	// 	navContainer.to("p31");
	// 	var oModel = new sap.ui.model.json.JSONModel();
	// 	oModel.setData({ modelData: initiatedWoJSONArray });
	// 	oTableWorkorder.setModel(oModel);
	// 	oTableWorkorder.bindItems({
	// 		path: "/modelData",
	// 		template: workorderTemplate
	// 	});
	// }
});
var woGrabStatuslistItem4 = new sap.m.StandardListItem({
	title: oBundle.getText("Reject"),
	icon: "sap-icon://reset",
	iconInset: true,unread: false,info: "0",//type:"Navigation",
	infoState: "Error",
	// press:function (event){
	// 	sideNavigation.setSelectedKey("p31");
	// 	navContainer.to("p31");
	// 	var oModel = new sap.ui.model.json.JSONModel();
	// 	oModel.setData({ modelData: inProgressWoJSONArray });
	// 	oTableWorkorder.setModel(oModel);
	// 	oTableWorkorder.bindItems({
	// 		path: "/modelData",
	// 		template: workorderTemplate
	// 	});
	// }
});
var woGrabStatuslistItem5 = new sap.m.StandardListItem({
	title: oBundle.getText("Pending_Approval"),
	icon: sap.ui.core.IconPool.getIconURI("pending"),
	iconInset: true,unread: false,info: "0",//type:"Navigation",
	infoState: "Error",
	// press:function (event){
	// 	sideNavigation.setSelectedKey("p31");
	// 	navContainer.to("p31");
	// 	var oModel = new sap.ui.model.json.JSONModel();
	// 	oModel.setData({ modelData: onHoldWoJSONArray });
	// 	oTableWorkorder.setModel(oModel);
	// 	oTableWorkorder.bindItems({
	// 		path: "/modelData",
	// 		template: workorderTemplate
	// 	});
	// }
});
var woGrabStatuslistItem6 = new sap.m.StandardListItem({
	title: oBundle.getText("Closed"),
	icon: "sap-icon://decline",
	iconInset: true,unread: false,info: "0",//type:"Navigation",
	infoState: "Error",
	// press:function (event){
	// 	sideNavigation.setSelectedKey("p31");
	// 	navContainer.to("p31");
	// 	var oModel = new sap.ui.model.json.JSONModel();
	// 	oModel.setData({ modelData: reworkWoJSONArray });
	// 	oTableWorkorder.setModel(oModel);
	// 	oTableWorkorder.bindItems({
	// 		path: "/modelData",
	// 		template: workorderTemplate
	// 	});
	// }
});
var woGrabStatuslistItem7 = new sap.m.StandardListItem({
    title: oBundle.getText("GRN"),
    icon: "sap-icon://my-sales-order",
    iconInset: true,unread: false,info: "0",//type:"Navigation",
    infoState: "Error",
    // press:function (event){
    // 	sideNavigation.setSelectedKey("p31");
    // 	navContainer.to("p31");
    // 	var oModel = new sap.ui.model.json.JSONModel();
    // 	oModel.setData({ modelData: postpondWoJSONArray });
    // 	oTableWorkorder.setModel(oModel);
    // 	oTableWorkorder.bindItems({
    // 		path: "/modelData",
    // 		template: workorderTemplate
    // 	});
    // }
});
var woGrabStatuslistItem8 = new sap.m.StandardListItem({
    title: oBundle.getText("Cancelled"),
    icon: "sap-icon://cancel",
    iconInset: true,unread: false,info: "0",//type:"Navigation",
    infoState: "Error",
    // press:function (event){
    //     sideNavigation.setSelectedKey("p31");
    //     navContainer.to("p31");
    //     var oModel = new sap.ui.model.json.JSONModel();
    //     oModel.setData({ modelData: postpondWoJSONArray });
    //     oTableWorkorder.setModel(oModel);
    //     oTableWorkorder.bindItems({
    //         path: "/modelData",
    //         template: workorderTemplate
    //     });
    // }
});
var woGrabStatuslistItem9 = new sap.m.StandardListItem({
    title: oBundle.getText("Need Verification"),
    icon: sap.ui.core.IconPool.getIconURI("pending"),
    iconInset: true,unread: false,info: "0",//type:"Navigation",
    infoState: "Error",
});
grabHomeList1.addItem(woGrabStatuslistItem1);
grabHomeList1.addItem(woGrabStatuslistItem2);
grabHomeList1.addItem(woGrabStatuslistItem3);
grabHomeList1.addItem(woGrabStatuslistItem4);
grabHomeList1.addItem(woGrabStatuslistItem9);
grabHomeList1.addItem(woGrabStatuslistItem5);
grabHomeList1.addItem(woGrabStatuslistItem6);
grabHomeList1.addItem(woGrabStatuslistItem7);
grabHomeList1.addItem(woGrabStatuslistItem8);
}
//-------------------------------------------------GRAB Workorder Home End-------------------------------------------------------------------

//-------------------------------------------------GRAB Workorder Status Chart Start---------------------------------------------------------
{
	var oPieChartGrabWorkorderStatus = new sap.viz.ui5.controls.VizFrame({
		'uiConfig': {
			'applicationSet': 'fiori'
		},
		'width': '100%',
		'height': '300px',
		'vizType': 'pie'
	});
	
	var oDatasetPieChartGrabWoStatus = new sap.viz.ui5.data.FlattenedDataset({
		dimensions: [{
			name: 'Status',
			value: "{status}"
		}],
		measures: [{
			name: 'Number',
			value: '{count}'
		}],
		data: {
			path: "/modelData"
		}
	});
	
	oPieChartGrabWorkorderStatus.setDataset(oDatasetPieChartGrabWoStatus);
	oPieChartGrabWorkorderStatus.setVizProperties({
		plotArea: {
			dataLabel: {visible: true},
			legend:{title:{visible: true}},
			colorPalette : ['#007bff','#17a2b8','#ffc107','#dc3545','#6c757d','#a60037','#337494','#e76500']
		},
		legendGroup: {layout:{position : 'bottom'}},
		title:{visible: true,text: oBundle.getText("Status")}
	});
	
	oPieChartGrabWorkorderStatus.addFeed(new sap.viz.ui5.controls.common.feeds.FeedItem({
		'uid': "size",
		'type': "Measure",
		'values': ["Number"]
	}));
	oPieChartGrabWorkorderStatus.addFeed(new sap.viz.ui5.controls.common.feeds.FeedItem({
		'uid': "color",
		'type': "Dimension",
		'values': ["Status"]
	}));
}
//-------------------------------------------------GRAB Workorder Status Chart End-----------------------------------------------------------




//-------------------------------------------------GRAB Inspection Home Start----------------------------------------------------------------
{
var homeListGrabInspection = new sap.m.List({
    showUnread: true,
    backgroundDesign: sap.m.BackgroundDesign.Transparent,
}).addStyleClass("homelist");

var homeListGrabInspectionItem1 = new sap.m.StandardListItem({
    title: oBundle.getText("Total_Inspection"),
    icon: sap.ui.core.IconPool.getIconURI("inspection"),
    iconInset: true,unread: false,//type:"Navigation",
	info: "0",
    // press:function (event){
    //     sideNavigation.setSelectedKey("p21");
    //     navContainer.to("p21");
        
    //     var oModel = new sap.ui.model.json.JSONModel();
    //     oModel.setData({ modelData: allInspectionJSONArray });

    //     oTableInspection.setModel(oModel);
    //     oTableInspection.bindItems({
    //         path: "/modelData",
    //         template: inspectionTemplate
    //     });
    // }
});
var homeListGrabInspectionItem2 = new sap.m.StandardListItem({
    title: oBundle.getText("Good_Inspection"),
    icon: sap.ui.core.IconPool.getIconURI("complete"),
    iconInset: true,unread: false,//type:"Navigation",
    info: "0",infoState: "Success",
    // press:function (event){
    //     sideNavigation.setSelectedKey("p21");
    //     navContainer.to("p21");

    //     var oModel = new sap.ui.model.json.JSONModel();
    //     oModel.setData({ modelData: goodInspectionJSONArray });

    //     oTableInspection.setModel(oModel);
    //     oTableInspection.bindItems({
    //         path: "/modelData",
    //         template: inspectionTemplate
    //     });
    // }
});
var homeListGrabInspectionItem3 = new sap.m.StandardListItem({
    title: oBundle.getText("Faulty_Inspection"),
    icon: sap.ui.core.IconPool.getIconURI("sys-cancel"),
    iconInset: true,unread: false,//type:"Navigation",
    info: "0",infoState: "Error",
    // press:function (event){
    //     sideNavigation.setSelectedKey("p21");
    //     navContainer.to("p21");
        
    //     var oModel = new sap.ui.model.json.JSONModel();
    //     oModel.setData({ modelData: faultyInspectionJSONArray });

    //     oTableInspection.setModel(oModel);
    //     oTableInspection.bindItems({
    //         path: "/modelData",
    //         template: inspectionTemplate
    //     });
    // }
});


homeListGrabInspection.addItem(homeListGrabInspectionItem1);
homeListGrabInspection.addItem(homeListGrabInspectionItem2);
homeListGrabInspection.addItem(homeListGrabInspectionItem3);
}
//-------------------------------------------------GRAB Inspection Home End------------------------------------------------------------------

//-------------------------------------------------GRAB Inspection Chat Start------------------------------------------------------------------
{

var oPieChartGrabInspectionCount = new sap.viz.ui5.controls.VizFrame({
	'uiConfig': {
		'applicationSet': 'fiori'
	},
	'width': '100%',
	'height': '200px',
	'vizType': 'donut',
	legendVisible:true
	
});

var oDatasetGrabInspectionCount = new sap.viz.ui5.data.FlattenedDataset({
	dimensions: [{
		name: 'Status',
		value: "{item}"
	}],
	measures: [{
		name: 'Number',
		value: '{count}'
	}],
	data: {
		path: "/modelData"
	}
});

oPieChartGrabInspectionCount.setDataset(oDatasetGrabInspectionCount);
oPieChartGrabInspectionCount.setVizProperties({
	plotArea: {
		dataLabel: {visible: true},
		
		legend:{title:{visible: false}},
		colorPalette : ['#19A979','#ED4A7B']
	},
	legendGroup: {layout:{position : 'right'}},
	title:{visible: false}
});

oPieChartGrabInspectionCount.addFeed(new sap.viz.ui5.controls.common.feeds.FeedItem({
	'uid': "size",
	'type': "Measure",
	'values': ["Number"]
}));
oPieChartGrabInspectionCount.addFeed(new sap.viz.ui5.controls.common.feeds.FeedItem({
	'uid': "color",
	'type': "Dimension",
	'values': ["Status"]
}));
}
//-------------------------------------------------GRAB Inspection Chart End------------------------------------------------------------------




//------------------------------------------------GRAB Schedules Table Start -----------------------------------------------------------------
{

}
//------------------------------------------------GRAB Schedules Table ENd   -----------------------------------------------------------------

var oTableUpcommingDashSchedule = oTableSchedule.clone();
var upcommingScheduleDashTemplate = scheduleTemplate.clone();
//oTableUpcommingDashSchedule.destroyHeaderToolbar();
oTableUpcommingDashSchedule.setHeaderToolbar(new sap.m.OverflowToolbar({
	content: [   
		new sap.m.ToolbarSpacer(),
		new sap.m.Button({ text:oBundle.getText("Excel_Export"), type:sap.m.ButtonType.Emphasized,
			icon: "sap-icon://excel-attachment",
			press: function (e) { upcommingScheduleExcelExport(); }
		})	
  ]})
);


function upcommingScheduleExcelExport(){


	var xlsHeader = [oBundle.getText("Schedule_ID"), 
			oBundle.getText("Title"),

			oBundle.getText("License_Number"),
			oBundle.getText("Vehicle_Model"),

			// oBundle.getText("Due KM"),
			oBundle.getText("Due_Date"),
			oBundle.getText("Workorder")
		];

		var dataObject = [];
		var tableItem = oTableUpcommingDashSchedule.getItems();
	
		for(var i=0;i<tableItem.length;i++){

			var Due1 = tableItem[i].getCells()[3].getItems()[0].getItems()[1].getText();
			var Due2 = tableItem[i].getCells()[3].getItems()[0].getItems()[2].getText();
			var Due3 = tableItem[i].getCells()[3].getItems()[1].getItems()[1].getText();
			var Due4 = tableItem[i].getCells()[3].getItems()[1].getItems()[2].getText();

			var item = tableItem[i].getBindingContext().getObject();

			var  schedule_id =  item.schedule_id;
			var  cycle_count =  item.cycle_count;
			var  schedule_title =  item.schedule_title;

			var  vehicle_number =  item.license_number;
			var  vehicle_name =  item.vehicle_model;
			var  workorder_number =  item.workorder_number;

			dataObject.push({"1":schedule_id+"-"+cycle_count,
							"2":schedule_title,
							"3":vehicle_number,
							"4":vehicle_name,

							// "5":Due1+" - "+Due2,
							"5":Due3+" - "+Due4,
							"6":workorder_number
						});
		}

		var createXLSLFormatObj = [];

		createXLSLFormatObj.push(xlsHeader);
		$.each(dataObject, function(index, value) {
			var innerRowData = [];
			$.each(value, function(ind, val) { innerRowData.push(val);});
			createXLSLFormatObj.push(innerRowData);
		});

		var filename = "Schedule_Upcoming_Export.xlsx";
		var sheet_name = "Data";

		var wb = XLSX.utils.book_new();
		var ws = XLSX.utils.aoa_to_sheet(createXLSLFormatObj);

		XLSX.utils.book_append_sheet(wb, ws, sheet_name);
		XLSX.writeFile(wb, filename);

}




var oLayoutBlockGrab1 =  new sap.ui.layout.BlockLayout({
	background: sap.ui.layout.BlockBackgroundType.Dashboard,
	content: [
		new sap.ui.layout.BlockLayoutRow({
			content: [
				new sap.ui.layout.BlockLayoutCell({
					id:"grab_dash_workorder",
					content: new sap.ui.layout.AlignedFlowLayout({
							content: [ grabHomeList1,oPieChartGrabWorkorderStatus]	
						}),
					width: 2,
					titleAlignment:"Center",
					title: oBundle.getText("Workorder_Summary")
				}),   
				new sap.ui.layout.BlockLayoutCell({
					id:"grab_dash_inspection",
                    content: [homeListGrabInspection,oPieChartGrabInspectionCount],
                    width: 1,
                    titleAlignment:"Center",
                    title: oBundle.getText("Inspection_Conducted")
                }),           
			]
		}),
	]
}).addStyleClass('homeLayout');

var oLayoutBlockGrab2 =  new sap.ui.layout.BlockLayout({
	background: sap.ui.layout.BlockBackgroundType.Dashboard,
	content: [
		new sap.ui.layout.BlockLayoutRow({
			content: [
				new sap.ui.layout.BlockLayoutCell({
				id:"grab_dash_scheduler",
				content: new sap.m.ScrollContainer({
					vertical: true,
					width:"100%",
					height:"500px",
					horizontal: true,
					content: [oTableUpcommingDashSchedule]
				}),
				width: 1,
				titleAlignment:"Center",
				title: oBundle.getText("Upcoming_Schedules")
			})
			]
		}),
		
	]
}).addStyleClass('homeLayout');





var oLayoutBlockGrabDashboard =  new sap.ui.layout.BlockLayout({
	content: [
		new sap.ui.layout.BlockLayoutRow({
			content: [
				new sap.ui.layout.BlockLayoutCell({content: SegmentedGrabGroup,width: 6})
			]
		}),customDateBlock,
		new sap.ui.layout.BlockLayoutRow({
			content: [new sap.ui.layout.BlockLayoutCell({content: oLayoutBlockGrab1,width: 1})]
		}),
		new sap.ui.layout.BlockLayoutRow({
			content: [new sap.ui.layout.BlockLayoutCell({content: oLayoutBlockGrab2,width: 1})]
		}),
		
	]
}).addStyleClass('homeLayout1');

/*
function assignWorkorderDashboardCount(){


	results = grab4WAllWoJSONArray;
	let totalWo = 0;
	let totalPendingWo = 0;
	let totalOpenWo = 0;
	let totalCompletedWo = 0;
	let totalClosedWo = 0;
	let totalGRNWo = 0;
	let totalRejectWo = 0;
	let totalCancelledWo = 0;
	for (var i = 0; i < results.length; i++) {

		var created_date = results[i]['created_date'];
		var  oDate = new Date(created_date.split(" ")[0]);
		
		if(segmentedDate1 <= oDate && oDate <= segmentedDate2){
			totalWo++;  
			if(results[i]['wo_status'] == "Pending Approval"){
				totalPendingWo++;
			}else if (results[i]['wo_status'] == "Open"){ totalOpenWo++;
			}else if (results[i]['wo_status'] == "Completed"){ totalCompletedWo++;
			}else if (results[i]['wo_status'] == "Closed"){ totalClosedWo++;
			}else if (results[i]['wo_status'] == "Cancelled"){ totalCancelledWo++;
			}else if (results[i]['wo_status'] == "GRN"){ totalGRNWo++;
			}else if (results[i]['wo_status'] == "Reject"){  totalRejectWo++; }

		}
	};

	woGrabStatuslistItem1.setInfo(totalWo);
	woGrabStatuslistItem2.setInfo(totalCompletedWo);
	woGrabStatuslistItem3.setInfo(totalOpenWo);
	woGrabStatuslistItem4.setInfo(totalRejectWo);
	woGrabStatuslistItem5.setInfo(totalPendingWo);
	woGrabStatuslistItem6.setInfo(totalClosedWo);
	woGrabStatuslistItem7.setInfo(totalGRNWo);
	woGrabStatuslistItem8.setInfo(totalCancelledWo);


	
	let oDataGrabWoStatus = [];
	oDataGrabWoStatus.push({ status: oBundle.getText("Open"), count: totalOpenWo});
	oDataGrabWoStatus.push({ status: oBundle.getText("Completed"), count: totalCompletedWo});
	oDataGrabWoStatus.push({ status: oBundle.getText("Closed"), count: totalClosedWo});
	oDataGrabWoStatus.push({ status: oBundle.getText("Cancelled"), count: totalCancelledWo});
	oDataGrabWoStatus.push({ status: oBundle.getText("GRN"), count: totalGRNWo});
	oDataGrabWoStatus.push({ status: oBundle.getText("Reject"), count: totalRejectWo});
	oDataGrabWoStatus.push({ status: oBundle.getText("Pending_Approval"), count: totalPendingWo});

	var oModelPieChartWoStatus = new sap.ui.model.json.JSONModel();
	oModelPieChartWoStatus.setData({ modelData: oDataGrabWoStatus });
	oPieChartGrabWorkorderStatus.setModel(oModelPieChartWoStatus);
	oPieChartGrabWorkorderStatus.setBusy(false);


}*/
